package h23.numberplace;

import java.util.Random;

public class Generator {

	int[][] answer = new int[9][9];       // 完成盤面
	int[][] answerField = new int[9][9];  // 初期盤面生成、解答時に一時的に使われる盤面
	int[][] question = new int[9][9];     // 問題盤面
	int[][][] field = new int[9][9][9];   // 記入できる値を記したフィールド。解答時に使用。


	// 初期盤面(解答)を一つ作成する
	Generator(int level) {
		createAnswer();
		createQuestion(level);
	}


	// 解答をインスタンス変数に格納
	private void createAnswer() {
		depthFirstSearch(0, 0);
	}


	// 再帰による深さ優先探索で初期盤面を生成する
	private boolean depthFirstSearch(int x, int y) {
		if (x >= 9) {
			// answerFieldからanswerにコピー
			for (int i = 0; i < answerField.length; i++) {
				for (int j = 0; j < answerField[i].length; j++) {
					answer[i][j] = answerField[i][j];
					answerField[i][j] = 0;
				}
			}

			return true;
		}

//		if (answer[x][y] != 0) {
//			if (y >= 8) {
//				depthFirstSearch(x+1, 0);
//			} else {
//				depthFirstSearch(x, y+1);
//			}
//			return;
//		}

		int[] insertNumsAry = {1,2,3,4,5,6,7,8,9};
		shuffle(insertNumsAry);

		for (int i = 0; i < insertNumsAry.length; i++) {
			int num = insertNumsAry[i];
			if (canWrite(num, x, y)) {
				answerField[x][y] = num;
				if (y >= 8) {
					if (depthFirstSearch(x+1, 0)) {
						return true;
					}
				} else {
					if (depthFirstSearch(x, y+1)) {
						return true;
					}
				}
			}
		}

		answerField[x][y] = 0;
		return false;
	}


	private int[] shuffle(int[] array) {
		for (int i = 0; i < array.length; i++) {
			int tmp;
			int dst = (int) Math.floor(Math.random() * (i + 1));
			tmp = array[i];
			array[i] = array[dst];
			array[dst] = tmp;
		}
		return array;
	}


	private boolean canWrite(int num, int rowNum, int colNum) {
		if (existNumInRow(num, rowNum) || existNumInColumn(num, colNum) || existNumInBox(num, rowNum, colNum)) {
			return false;
		} else {
			return true;
		}
	}


	private boolean existNumInRow(int num, int rowNum) {
		for (int i = 0; i < answerField[rowNum].length; i++) {
			if (answerField[rowNum][i] == num) {
				return true;
			}
		}

		return false;
	}


	private boolean existNumInColumn(int num, int colNum) {
		for (int i = 0; i < answerField.length; i++) {
			if (answerField[i][colNum] == num) {
				return true;
			}
		}

		return false;
	}


	private boolean existNumInBox(int num, int rowNum, int colNum) {
		//System.out.print(rowNum + "," + colNum + ": ");
		for (int i = ((rowNum/3)*3); i <= ((rowNum/3)*3 + 2); i++) {
			for (int j = ((colNum/3)*3); j <= ((colNum/3)*3 + 2); j++) {
				//System.out.print("("+i+","+j+"), ");
				if (answerField[i][j] == num) {
					return true;
				}
			}
		}
		//System.out.println("//");

		return false;
	}


	// 問題の盤面を作成し、フィールド変数に格納する
	private void createQuestion(int level) {
		final int LOOP_LIMIT = 80;
		int[][] tempQuestion = new int[9][9];
		int tempNum;
		Random rand = new Random();
		int delRowIndex = rand.nextInt(9);
		int delColIndex = rand.nextInt(9);
		int loopCount;
		int compBlankNum = 20 + (level * 3);
		int i;

		for (int r = 0; r < answer.length; r++) {
			for (int c = 0; c < answer[r].length; c++) {
				question[r][c] = answer[r][c];
				tempQuestion[r][c] = answer[r][c];
			}
		}

		tempNum = tempQuestion[delRowIndex][delColIndex];
		tempQuestion[delRowIndex][delColIndex] = 0;

		// 規定回数解答に失敗する、もしくはレベル規定の空白を作り終わるまで値を削っていく
		loopCount = 0;
		i = 0;
		while ((loopCount < LOOP_LIMIT) && (i <= compBlankNum)) {
			// 答えられたらquestionを削ったあと、次の値を削る
			// 答えられなかったら削った値を戻して別の値を削る
			if (answer(tempQuestion)) {
				// questionを削る
				question[delRowIndex][delColIndex] = 0;
				loopCount = 0;
				i++;
			} else {
				// 削った値を戻す
				tempQuestion[delRowIndex][delColIndex] = tempNum;
				loopCount++;
			}

			// 次の値を削る
			do {
				delRowIndex = rand.nextInt(9);
					delColIndex = rand.nextInt(9);
			} while(tempQuestion[delRowIndex][delColIndex] == 0);
			tempNum = tempQuestion[delRowIndex][delColIndex];
			tempQuestion[delRowIndex][delColIndex] = 0;
		}
	}


	// 確定箇所記入のみで解答可能であればtrue
	public boolean answer(int[][] q) {
		boolean filledIn;
		boolean complete;
		initializeField(q);

		for (;;) {
			filledIn = false;

			for (int r = 0; r < field.length; r++) {
				for (int c = 0; c < field[r].length; c++) {
					// field[r][l] に記入可能な数字の数を数える
					int writableNums = 0;
					for (int i = 0; i < field[r][c].length; i++) {
						if (field[r][c][i] != 0) {
							writableNums++;
						}
					}

					if (writableNums == 1) {
						// 記入候補が1つの空白を埋めて、fieldを更新
						for (int i = 0; i < field[r][c].length; i++) {
							if (field[r][c][i] != 0) {
								writeNumAndFieldUpdate(i, r, c);
								filledIn = true;
							}
						}
					} else if (writableNums > 1) {
						// 各空白で記入候補の数字を見ていき、
						// その数字が行、列、ボックスでそこにしかなければそこ空白を記入してfieldを更新
						for (int i = 0; i < field[r][c].length; i++) {
							if (field[r][c][i] != 0) {
								if (canFillIn(i, r, c)) {
									writeNumAndFieldUpdate(i, r, c);
									filledIn = true;
								}
							}
						}
					}
				}
			}

			// answerFieldに0が残っているか確認
			complete = true;
			for (int r = 0; r < answerField.length; r++) {
				for (int c = 0; c < answerField[r].length; c++) {
					if (answerField[r][c] == 0) {
						complete = false;
					}
				}
			}
			if (complete) {
				return true;
			}

//			print3Field(field);
//			printField(answerField);
//			System.out.println();

			// 書き込みせずにループを終えた場合失敗
			if (!filledIn) {
				return false;
			}
		}
	}


	private void initializeField(int[][] q) {
		// answerFieldにquestionをコピー
		for (int r = 0; r < answerField.length; r++) {
			for (int c = 0; c < answerField[r].length; c++) {
				answerField[r][c] = q[r][c];
			}
		}

		// fieldの作成
		for (int r = 0; r < field.length; r++) {
			for (int c = 0; c < field[r].length; c++) {
				for (int num = 1; num <= field[r][c].length; num++) {
					if ((q[r][c] == 0) &&
							!existNumInRow(num, r) &&
							!existNumInColumn(num, c) &&
							!existNumInBox(num, r, c)) {
						field[r][c][num-1] = 1;
					}
				}
			}
		}
	}


	// answerFieldの空白に決定した数字を書き込む
	private void writeNumAndFieldUpdate(int i, int r, int c) {
		field[r][c][i] = 0;
		answerField[r][c] = i+1;
		deleteNumInRowColBox(i, r, c);
		deleteAllNumInTheSquare(r, c);
	}


	// field[r][c]に記入した値を、その行、列、ボックスから削除する
	private void deleteNumInRowColBox(int i, int r, int c) {
		deleteNumInRow(i, r);
		deleteNumInCol(i, c);
		deleteNumInBox(i, r, c);
	}


	// 書き込んだマスのfieldを0で埋める
	private void deleteAllNumInTheSquare(int r, int c) {
		for (int i = 0; i < field[r][c].length; i++) {
			field[r][c][i] = 0;
		}
	}


	private void deleteNumInRow(int i, int r) {
		for (int c = 0; c < field[r].length; c++) {
			field[r][c][i] = 0;
		}
	}

	private void deleteNumInCol(int i, int c) {
		for (int r = 0; r < field.length; r++) {
			field[r][c][i] = 0;
		}
	}

	private void deleteNumInBox(int i, int r, int c) {
		for (int rr = ((r/3)*3); rr <= ((r/3)*3 + 2); rr++) {
			for (int cc = ((c/3)*3); cc <= ((c/3)*3 + 2); cc++) {
				field[rr][cc][i] = 0;
			}
		}
	}


	private boolean canFillIn(int i, int r, int c) {
		if (!existWritableNumInRowExceptHere(i, r, c) ||
				!existWritableNumInColExceptHere(i, r, c) ||
				!existWritableNumInBoxExceptHere(i, r, c)) {
			return true;
		} else {
			return false;
		}
	}

	private boolean existWritableNumInRowExceptHere(int i, int r, int c) {
		for (int cc = 0; cc < field[r].length; cc++) {
			if ((c != cc) && (field[r][cc][i] == 1)) {
				return true;
			}
		}

		return false;
	}

	private boolean existWritableNumInColExceptHere(int i, int r, int c) {
		for (int rr = 0; rr < field.length; rr++) {
			if ((r != rr) && (field[rr][c][i] == 1)) {
				return true;
			}
		}

		return false;
	}

	private boolean existWritableNumInBoxExceptHere(int i, int r, int c) {
		for (int rr = ((r/3)*3); rr <= ((r/3)*3 + 2); rr++) {
			for (int cc = ((c/3)*3); cc <= ((c/3)*3 + 2); cc++) {
				if ((!((r == rr)&&(c == cc))) && (field[rr][cc][i] == 1)) {
					return true;
				}
			}
		}

		return false;
	}


	public int[][] getQuestion() {

		return question;
	}


	public int[][] getAnswer() {

		return answer;
	}




	// 以下デバッグ用 //////////////////////////////////////////////////////

	public static void main(String args[]) {
		Generator a = new Generator(1);

		int[][] ary = {
				{1,0,0,7,0,0,6,0,0},
				{0,2,0,0,0,0,0,5,0},
				{0,0,3,0,0,9,0,0,0},
				{7,0,0,4,0,0,0,0,8},
				{0,0,0,0,5,0,0,2,0},
				{0,0,0,0,0,6,1,0,0},
				{4,0,2,1,0,0,7,0,0},
				{0,0,0,0,0,7,0,8,0},
				{6,0,0,0,2,0,0,0,9}};

		printField(a.getAnswer());
		System.out.println();
		printField(a.getQuestion());
//		a.answer(ary);
//		printField(a.getAnswerField());
	}


	private int[][] getAnswerField() {
		return answerField;
	}


	private static void printAry(int[] f) {
		for (int i : f) {
			System.out.print(i);
		}
		System.out.println();
	}


	private static void printField(int[][] f) {
		for (int[] row : f) {
			for (int i : row) {
				System.out.print(i);
			}
			System.out.println();
		}
	}


	private static void print3Field(int[][][] f) {
		for (int[][] row : f) {
			for (int[] col : row) {
				for (int i : col) {
					System.out.print(i);
				}
				System.out.print(",");
			}
			System.out.println();
		}
	}

	public void test() {
		int[] ary = {1,2,3,4,5,6,7,8,9};

		int[] c;

		c = shuffle(ary).clone();
		printAry(c);
	}

}
